/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.el.parser;

import jakarta.el.ELException;
import jakarta.el.MethodInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jboss.el.lang.EvaluationContext;
import org.jboss.el.parser.AstClosure;
import org.jboss.el.parser.ValueSuffixNode;

public final class AstClosureSuffix
extends ValueSuffixNode {
    public AstClosureSuffix(int id) {
        super(id);
    }

    protected final AstClosure closure() {
        return (AstClosure)this.children[0];
    }

    protected static final Collection toCollection(Object base, boolean force) {
        if (base == null) {
            return null;
        }
        if (base instanceof Collection) {
            return (Collection)base;
        }
        if (base instanceof Map) {
            return ((Map)base).entrySet();
        }
        if (base.getClass().isArray()) {
            return Arrays.asList((Object[])base);
        }
        if (force) {
            throw new ELException(base.getClass().getName() + " is not an instance of Iterable or cannot be coerced to Iterable.");
        }
        return null;
    }

    protected static final Collection toCollection(Object base) {
        return AstClosureSuffix.toCollection(base, true);
    }

    public boolean isReadOnly(Object base, EvaluationContext ctx) throws ELException {
        Collection c = AstClosureSuffix.toCollection(base);
        if (c == null || c.isEmpty()) {
            return true;
        }
        AstClosure closure = this.closure();
        Object first = c.iterator().next();
        return closure.isReadOnly(first, ctx);
    }

    public Object getValue(Object base, EvaluationContext ctx) throws ELException {
        Collection c = AstClosureSuffix.toCollection(base);
        if (c == null) {
            return null;
        }
        if (c.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ClosureList r = new ClosureList(c.size());
        AstClosure closure = this.closure();
        for (Object o : c) {
            Object v = closure.getValue(o, ctx);
            if (v instanceof ClosureList) {
                r.addAll((ClosureList)v);
                continue;
            }
            r.add(v);
        }
        return r;
    }

    public Class getType(Object base, EvaluationContext ctx) throws ELException {
        return Collection.class;
    }

    public Object getTarget(Object base, EvaluationContext ctx) throws ELException {
        Collection c = AstClosureSuffix.toCollection(base);
        if (c == null || c.isEmpty()) {
            return null;
        }
        ClosureList r = new ClosureList(c.size());
        AstClosure closure = this.closure();
        for (Object o : c) {
            Object v = closure.getValue(o, ctx);
            if (v instanceof ClosureList) {
                r.addAll((ClosureList)v);
                continue;
            }
            r.add(v);
        }
        return r;
    }

    public MethodInfo getMethodInfo(Object base, EvaluationContext ctx, Class[] paramTypes) throws ELException {
        Collection c = AstClosureSuffix.toCollection(base);
        if (c == null || c.isEmpty()) {
            return null;
        }
        AstClosure closure = this.closure();
        Object first = c.iterator().next();
        return closure.getMethodInfo(first, ctx, paramTypes);
    }

    public Object invoke(Object base, EvaluationContext ctx, Class[] paramTypes, Object[] paramValues) throws ELException {
        Collection c = AstClosureSuffix.toCollection(base);
        if (c == null) {
            return null;
        }
        if (c.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ClosureList r = new ClosureList(c.size());
        AstClosure closure = this.closure();
        for (Object o : c) {
            Object v = closure.invoke(o, ctx, paramTypes, paramValues);
            if (v instanceof ClosureList) {
                r.addAll((ClosureList)v);
                continue;
            }
            r.add(v);
        }
        return r;
    }

    public void setValue(Object base, EvaluationContext ctx, Object value) throws ELException {
        Collection c = AstClosureSuffix.toCollection(base);
        if (c != null && !c.isEmpty()) {
            AstClosure closure = this.closure();
            for (Object o : c) {
                closure.setValue(o, ctx, value);
            }
        }
    }

    private static class ClosureList
    extends ArrayList {
        public ClosureList(int size) {
            super(size);
        }
    }
}

