/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.taglib.jsf_core;

import com.sun.faces.el.ELUtils;
import com.sun.faces.taglib.jsf_core.AbstractConverterTag;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.servlet.jsp.JspException;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.NumberConverter;

public class ConvertNumberTag
extends AbstractConverterTag {
    private static final long serialVersionUID = -2710405278792415110L;
    private static ValueExpression CONVERTER_ID_EXPR = null;
    private static final Logger LOGGER = FacesLogger.TAGLIB.getLogger();
    private ValueExpression currencyCodeExpression;
    private ValueExpression currencySymbolExpression;
    private ValueExpression groupingUsedExpression;
    private ValueExpression integerOnlyExpression;
    private ValueExpression maxFractionDigitsExpression;
    private ValueExpression maxIntegerDigitsExpression;
    private ValueExpression minFractionDigitsExpression;
    private ValueExpression minIntegerDigitsExpression;
    private ValueExpression localeExpression;
    private ValueExpression patternExpression;
    private ValueExpression typeExpression;
    private String currencyCode;
    private String currencySymbol;
    private boolean groupingUsed;
    private boolean integerOnly;
    private int maxFractionDigits;
    private int maxIntegerDigits;
    private int minFractionDigits;
    private int minIntegerDigits;
    private Locale locale;
    private String pattern;
    private String type;
    private boolean maxFractionDigitsSpecified;
    private boolean maxIntegerDigitsSpecified;
    private boolean minFractionDigitsSpecified;
    private boolean minIntegerDigitsSpecified;

    public ConvertNumberTag() {
        this.init();
    }

    public void release() {
        super.release();
        this.init();
    }

    private void init() {
        this.currencyCode = null;
        this.currencyCodeExpression = null;
        this.currencySymbol = null;
        this.currencySymbolExpression = null;
        this.groupingUsed = true;
        this.groupingUsedExpression = null;
        this.integerOnly = false;
        this.integerOnlyExpression = null;
        this.maxFractionDigits = 0;
        this.maxFractionDigitsExpression = null;
        this.maxFractionDigitsSpecified = false;
        this.maxIntegerDigits = 0;
        this.maxIntegerDigitsExpression = null;
        this.maxIntegerDigitsSpecified = false;
        this.minFractionDigits = 0;
        this.minFractionDigitsExpression = null;
        this.minFractionDigitsSpecified = false;
        this.minIntegerDigits = 0;
        this.minIntegerDigitsExpression = null;
        this.minIntegerDigitsSpecified = false;
        this.locale = null;
        this.localeExpression = null;
        this.pattern = null;
        this.patternExpression = null;
        this.type = "number";
        this.typeExpression = null;
        if (CONVERTER_ID_EXPR == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            ExpressionFactory factory = context.getApplication().getExpressionFactory();
            CONVERTER_ID_EXPR = factory.createValueExpression(context.getELContext(), "javax.faces.Number", String.class);
        }
    }

    public void setCurrencyCode(ValueExpression currencyCode) {
        this.currencyCodeExpression = currencyCode;
    }

    public void setCurrencySymbol(ValueExpression currencySymbol) {
        this.currencySymbolExpression = currencySymbol;
    }

    public void setGroupingUsed(ValueExpression groupingUsed) {
        this.groupingUsedExpression = groupingUsed;
    }

    public void setIntegerOnly(ValueExpression integerOnly) {
        this.integerOnlyExpression = integerOnly;
    }

    public void setMaxFractionDigits(ValueExpression maxFractionDigits) {
        this.maxFractionDigitsExpression = maxFractionDigits;
        this.maxFractionDigitsSpecified = true;
    }

    public void setMaxIntegerDigits(ValueExpression maxIntegerDigits) {
        this.maxIntegerDigitsExpression = maxIntegerDigits;
        this.maxIntegerDigitsSpecified = true;
    }

    public void setMinFractionDigits(ValueExpression minFractionDigits) {
        this.minFractionDigitsExpression = minFractionDigits;
        this.minFractionDigitsSpecified = true;
    }

    public void setMinIntegerDigits(ValueExpression minIntegerDigits) {
        this.minIntegerDigitsExpression = minIntegerDigits;
    }

    public void setLocale(ValueExpression locale) {
        this.localeExpression = locale;
    }

    public void setPattern(ValueExpression pattern) {
        this.patternExpression = pattern;
    }

    public void setType(ValueExpression type) {
        this.typeExpression = type;
    }

    public int doStartTag() throws JspException {
        super.setConverterId(CONVERTER_ID_EXPR);
        return super.doStartTag();
    }

    protected Converter createConverter() throws JspException {
        NumberConverter result = (NumberConverter)super.createConverter();
        assert (null != result);
        this.evaluateExpressions();
        result.setCurrencyCode(this.currencyCode);
        result.setCurrencySymbol(this.currencySymbol);
        result.setGroupingUsed(this.groupingUsed);
        result.setIntegerOnly(this.integerOnly);
        if (this.maxFractionDigitsSpecified) {
            result.setMaxFractionDigits(this.maxFractionDigits);
        }
        if (this.maxIntegerDigitsSpecified) {
            result.setMaxIntegerDigits(this.maxIntegerDigits);
        }
        if (this.minFractionDigitsSpecified) {
            result.setMinFractionDigits(this.minFractionDigits);
        }
        if (this.minIntegerDigitsSpecified) {
            result.setMinIntegerDigits(this.minIntegerDigits);
        }
        result.setLocale(this.locale);
        result.setPattern(this.pattern);
        result.setType(this.type);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void evaluateExpressions() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = facesContext.getELContext();
        if (this.currencyCodeExpression != null) {
            this.currencyCode = (String)ELUtils.evaluateValueExpression(this.currencyCodeExpression, elContext);
        }
        if (this.currencySymbolExpression != null) {
            this.currencySymbol = (String)ELUtils.evaluateValueExpression(this.currencySymbolExpression, elContext);
        }
        if (this.patternExpression != null) {
            this.pattern = (String)ELUtils.evaluateValueExpression(this.patternExpression, elContext);
        }
        if (this.typeExpression != null) {
            this.type = (String)ELUtils.evaluateValueExpression(this.typeExpression, elContext);
        }
        if (this.groupingUsedExpression != null) {
            this.groupingUsed = this.groupingUsedExpression.isLiteralText() ? Boolean.valueOf(this.groupingUsedExpression.getExpressionString()).booleanValue() : ((Boolean)ELUtils.evaluateValueExpression(this.groupingUsedExpression, elContext)).booleanValue();
        }
        if (this.integerOnlyExpression != null) {
            this.integerOnly = this.integerOnlyExpression.isLiteralText() ? Boolean.valueOf(this.integerOnlyExpression.getExpressionString()).booleanValue() : ((Boolean)ELUtils.evaluateValueExpression(this.integerOnlyExpression, elContext)).booleanValue();
        }
        if (this.maxFractionDigitsExpression != null) {
            this.maxFractionDigits = this.maxFractionDigitsExpression.isLiteralText() ? Integer.valueOf(this.maxFractionDigitsExpression.getExpressionString()).intValue() : ((Integer)ELUtils.evaluateValueExpression(this.maxFractionDigitsExpression, elContext)).intValue();
        }
        if (this.maxIntegerDigitsExpression != null) {
            this.maxIntegerDigits = this.maxIntegerDigitsExpression.isLiteralText() ? Integer.valueOf(this.maxIntegerDigitsExpression.getExpressionString()).intValue() : ((Integer)ELUtils.evaluateValueExpression(this.maxIntegerDigitsExpression, elContext)).intValue();
        }
        if (this.minFractionDigitsExpression != null) {
            this.minFractionDigits = this.minFractionDigitsExpression.isLiteralText() ? Integer.valueOf(this.minFractionDigitsExpression.getExpressionString()).intValue() : ((Integer)ELUtils.evaluateValueExpression(this.minFractionDigitsExpression, elContext)).intValue();
        }
        if (this.minIntegerDigitsExpression != null) {
            this.minIntegerDigits = this.minIntegerDigitsExpression.isLiteralText() ? Integer.valueOf(this.minIntegerDigitsExpression.getExpressionString()).intValue() : ((Integer)ELUtils.evaluateValueExpression(this.minIntegerDigitsExpression, elContext)).intValue();
        }
        if (this.localeExpression == null) return;
        if (this.localeExpression.isLiteralText()) {
            this.locale = ConvertNumberTag.getLocale(this.localeExpression.getExpressionString());
            return;
        }
        Object loc = ELUtils.evaluateValueExpression(this.localeExpression, elContext);
        if (loc == null) {
            this.locale = facesContext.getViewRoot().getLocale();
            return;
        }
        if (loc instanceof String) {
            this.locale = ConvertNumberTag.getLocale((String)loc);
            return;
        }
        if (loc instanceof Locale) {
            this.locale = (Locale)loc;
            return;
        }
        Object[] params = new Object[]{"locale", "java.lang.String or java.util.Locale", loc.getClass().getName()};
        if (!LOGGER.isLoggable(Level.SEVERE)) throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.EVAL_ATTR_UNEXPECTED_TYPE", params));
        LOGGER.log(Level.SEVERE, "jsf.core.tags.eval_result_not_expected_type", params);
        throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.EVAL_ATTR_UNEXPECTED_TYPE", params));
    }

    protected static Locale getLocale(String string) {
        if (string == null) {
            return Locale.getDefault();
        }
        if (string.length() > 2) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.core.taglib.invalid_locale_value", string);
            }
        } else {
            Object[] langs = Locale.getISOLanguages();
            Arrays.sort(langs);
            if (Arrays.binarySearch(langs, string) < 0 && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.core.taglib.invalid_language", string);
            }
        }
        return new Locale(string, "");
    }
}

