/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.compiler;

import com.sun.faces.facelets.compiler.Instruction;
import com.sun.faces.facelets.el.ELText;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

final class AttributeInstruction
implements Instruction {
    private final String alias;
    private final String attr;
    private final ELText txt;

    public AttributeInstruction(String alias, String attr, ELText txt) {
        this.alias = alias;
        this.attr = attr;
        this.txt = txt;
    }

    public void write(FacesContext context) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        try {
            ELContext elContext = context.getELContext();
            String val = this.txt.toString(elContext);
            if (val != null && val.length() != 0) {
                out.writeAttribute(this.attr, val, null);
            }
        }
        catch (ELException e) {
            throw new ELException(this.alias + ": " + e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new ELException(this.alias + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public Instruction apply(ExpressionFactory factory, ELContext ctx) {
        ELText nt = this.txt.apply(factory, ctx);
        if (nt == this.txt) {
            return this;
        }
        return new AttributeInstruction(this.alias, this.attr, nt);
    }

    public boolean isLiteral() {
        return this.txt.isLiteral();
    }
}

