/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.BaseContextMap;
import com.sun.faces.context.ExternalContextImpl;
import com.sun.faces.util.Util;
import jakarta.servlet.ServletContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitParameterMap
extends BaseContextMap<String> {
    private final ServletContext servletContext;

    public InitParameterMap(ServletContext newServletContext) {
        this.servletContext = newServletContext;
    }

    @Override
    public String get(Object key) {
        Util.notNull("key", key);
        String keyString = key.toString();
        return this.servletContext.getInitParameter(keyString);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    @Override
    public Collection<String> values() {
        return Collections.unmodifiableCollection(super.values());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.servletContext.getInitParameter(key.toString()) != null;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == ExternalContextImpl.theUnmodifiableMapClass && super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hashCode = 7 * this.servletContext.hashCode();
        Iterator<Map.Entry<String, String>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            hashCode += ((Object)i.next()).hashCode();
        }
        return hashCode;
    }

    @Override
    protected Iterator<Map.Entry<String, String>> getEntryIterator() {
        return new BaseContextMap.EntryIterator(this.servletContext.getInitParameterNames());
    }

    @Override
    protected Iterator<String> getKeyIterator() {
        return new BaseContextMap.KeyIterator(this.servletContext.getInitParameterNames());
    }

    @Override
    protected Iterator<String> getValueIterator() {
        return new BaseContextMap.ValueIterator(this.servletContext.getInitParameterNames());
    }
}

