/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.Verifier;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import jakarta.servlet.ServletContext;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.FacesBehavior;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BehaviorConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String BEHAVIOR = "behavior";
    private static final String BEHAVIOR_ID = "behavior-id";
    private static final String BEHAVIOR_CLASS = "behavior-class";

    public void process(ServletContext sc, DocumentInfo[] documentInfos) throws Exception {
        this.processAnnotations(FacesBehavior.class);
        for (int i = 0; i < documentInfos.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing behavior elements for document: ''{0}''", documentInfos[i].getSourceURI()));
            }
            Document document = documentInfos[i].getDocument();
            String namespace = document.getDocumentElement().getNamespaceURI();
            NodeList behaviors = document.getDocumentElement().getElementsByTagNameNS(namespace, BEHAVIOR);
            if (behaviors == null || behaviors.getLength() <= 0) continue;
            this.addBehaviors(behaviors, namespace);
        }
        this.invokeNext(sc, documentInfos);
    }

    private void addBehaviors(NodeList behaviors, String namespace) throws XPathExpressionException {
        Application app = this.getApplication();
        Verifier verifier = Verifier.getCurrentInstance();
        int size = behaviors.getLength();
        for (int i = 0; i < size; ++i) {
            Node behavior = behaviors.item(i);
            NodeList children = ((Element)behavior).getElementsByTagNameNS(namespace, "*");
            String behaviorId = null;
            String behaviorClass = null;
            int csize = children.getLength();
            for (int c = 0; c < csize; ++c) {
                Node n = children.item(c);
                if (n.getNodeType() != 1) continue;
                if (BEHAVIOR_ID.equals(n.getLocalName())) {
                    behaviorId = this.getNodeText(n);
                    continue;
                }
                if (!BEHAVIOR_CLASS.equals(n.getLocalName())) continue;
                behaviorClass = this.getNodeText(n);
            }
            if (behaviorId == null || behaviorClass == null) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.addBehavior({0},{1})", behaviorId, behaviorClass));
            }
            if (verifier != null) {
                verifier.validateObject(Verifier.ObjectType.BEHAVIOR, behaviorClass, Behavior.class);
            }
            app.addBehavior(behaviorId, behaviorClass);
        }
    }
}

