/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ApplicationResourceBundle;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.el.ChainAwareVariableResolver;
import com.sun.faces.el.DummyPropertyResolverImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.el.ELResolver;
import jakarta.servlet.ServletContext;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ResourceHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.event.NamedEvent;
import javax.faces.event.SystemEventListener;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.validation.ValidatorFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String APPLICATION = "application";
    private static final String ACTION_LISTENER = "action-listener";
    private static final String DEFAULT_RENDERKIT_ID = "default-render-kit-id";
    private static final String DEFAULT_VALIDATORS = "default-validators";
    private static final String VALIDATOR_ID = "validator-id";
    private static final String MESSAGE_BUNDLE = "message-bundle";
    private static final String NAVIGATION_HANDLER = "navigation-handler";
    private static final String VIEW_HANDLER = "view-handler";
    private static final String STATE_MANAGER = "state-manager";
    private static final String RESOURCE_HANDLER = "resource-handler";
    private static final String EL_RESOLVER = "el-resolver";
    private static final String PROPERTY_RESOLVER = "property-resolver";
    private static final String VARIABLE_RESOLVER = "variable-resolver";
    private static final String DEFAULT_LOCALE = "default-locale";
    private static final String SUPPORTED_LOCALE = "supported-locale";
    private static final String RESOURCE_BUNDLE = "resource-bundle";
    private static final String BASE_NAME = "base-name";
    private static final String VAR = "var";
    private static final String RES_DESCRIPTIONS = "description";
    private static final String RES_DISPLAY_NAMES = "display-name";
    private static final String SYSTEM_EVENT_LISTENER = "system-event-listener";
    private static final String SYSTEM_EVENT_LISTENER_CLASS = "system-event-listener-class";
    private static final String SYSTEM_EVENT_CLASS = "system-event-class";
    private static final String SOURCE_CLASS = "source-class";

    @Override
    public void process(ServletContext sc, DocumentInfo[] documentInfos) throws Exception {
        Application app = this.getApplication();
        ApplicationAssociate associate = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext());
        LinkedHashMap<String, Node> viewHandlers = new LinkedHashMap<String, Node>();
        LinkedHashSet<String> defaultValidatorIds = null;
        for (int i = 0; i < documentInfos.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing application elements for document: ''{0}''", documentInfos[i].getSourceURI()));
            }
            Document document = documentInfos[i].getDocument();
            String namespace = document.getDocumentElement().getNamespaceURI();
            NodeList applicationElements = document.getDocumentElement().getElementsByTagNameNS(namespace, APPLICATION);
            if (applicationElements == null || applicationElements.getLength() <= 0) continue;
            int asize = applicationElements.getLength();
            for (int a = 0; a < asize; ++a) {
                Node appElement = applicationElements.item(a);
                NodeList children = ((Element)appElement).getElementsByTagNameNS(namespace, "*");
                if (children == null || children.getLength() <= 0) continue;
                int csize = children.getLength();
                for (int c = 0; c < csize; ++c) {
                    Node n = children.item(c);
                    if (MESSAGE_BUNDLE.equals(n.getLocalName())) {
                        this.setMessageBundle(app, n);
                        continue;
                    }
                    if (DEFAULT_RENDERKIT_ID.equals(n.getLocalName())) {
                        this.setDefaultRenderKitId(app, n);
                        continue;
                    }
                    if (ACTION_LISTENER.equals(n.getLocalName())) {
                        this.addActionListener(sc, app, n);
                        continue;
                    }
                    if (NAVIGATION_HANDLER.equals(n.getLocalName())) {
                        this.setNavigationHandler(sc, app, n);
                        continue;
                    }
                    if (VIEW_HANDLER.equals(n.getLocalName())) {
                        String viewHandler = this.getNodeText(n);
                        if (viewHandler == null) continue;
                        viewHandlers.put(viewHandler, n);
                        continue;
                    }
                    if (STATE_MANAGER.equals(n.getLocalName())) {
                        this.setStateManager(sc, app, n);
                        continue;
                    }
                    if (EL_RESOLVER.equals(n.getLocalName())) {
                        this.addELResolver(sc, associate, n);
                        continue;
                    }
                    if (PROPERTY_RESOLVER.equals(n.getLocalName())) {
                        this.addPropertyResolver(sc, associate, n);
                        continue;
                    }
                    if (VARIABLE_RESOLVER.equals(n.getLocalName())) {
                        this.addVariableResolver(sc, associate, n);
                        continue;
                    }
                    if (DEFAULT_LOCALE.equals(n.getLocalName())) {
                        this.setDefaultLocale(app, n);
                        continue;
                    }
                    if (SUPPORTED_LOCALE.equals(n.getLocalName())) {
                        this.addSupportedLocale(app, n);
                        continue;
                    }
                    if (RESOURCE_BUNDLE.equals(n.getLocalName())) {
                        this.addResouceBundle(associate, n);
                        continue;
                    }
                    if (RESOURCE_HANDLER.equals(n.getLocalName())) {
                        this.setResourceHandler(sc, app, n);
                        continue;
                    }
                    if (SYSTEM_EVENT_LISTENER.equals(n.getLocalName())) {
                        this.addSystemEventListener(sc, app, n);
                        continue;
                    }
                    if (DEFAULT_VALIDATORS.equals(n.getLocalName())) {
                        if (defaultValidatorIds == null) {
                            defaultValidatorIds = new LinkedHashSet<String>();
                            continue;
                        }
                        defaultValidatorIds.clear();
                        continue;
                    }
                    if (!VALIDATOR_ID.equals(n.getLocalName())) continue;
                    defaultValidatorIds.add(this.getNodeText(n));
                }
            }
        }
        this.registerDefaultValidatorIds(app, defaultValidatorIds);
        this.processViewHandlers(sc, app, viewHandlers);
        this.processAnnotations(NamedEvent.class);
        this.invokeNext(sc, documentInfos);
    }

    private void registerDefaultValidatorIds(Application application, LinkedHashSet<String> defaultValidatorIds) {
        if (defaultValidatorIds == null) {
            WebConfiguration webConfig;
            defaultValidatorIds = new LinkedHashSet();
            if (ApplicationConfigProcessor.isBeanValidatorAvailable() && !(webConfig = WebConfiguration.getInstance()).isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisableDefaultBeanValidator)) {
                defaultValidatorIds.add("javax.faces.Bean");
            }
        }
        for (String validatorId : defaultValidatorIds) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.addDefaultValidatorId({0})", validatorId));
            }
            application.addDefaultValidatorId(validatorId);
        }
    }

    static boolean isBeanValidatorAvailable() {
        boolean result = false;
        String beansValidationAvailabilityCacheKey = "javax.faces.BEANS_VALIDATION_AVAILABLE";
        Map<String, Object> appMap = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        if (appMap.containsKey("javax.faces.BEANS_VALIDATION_AVAILABLE")) {
            result = (Boolean)appMap.get("javax.faces.BEANS_VALIDATION_AVAILABLE");
        } else {
            block13: {
                try {
                    InitialContext initialContext;
                    block14: {
                        Thread.currentThread().getContextClassLoader().loadClass("javax.validation.MessageInterpolator");
                        Object cachedObject = appMap.get("javax.faces.validator.beanValidator.ValidatorFactory");
                        if (cachedObject instanceof ValidatorFactory) {
                            result = true;
                            break block13;
                        }
                        initialContext = null;
                        try {
                            initialContext = new InitialContext();
                        }
                        catch (NoClassDefFoundError nde) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, nde.toString(), nde);
                            }
                        }
                        catch (NamingException ne) {
                            if (!LOGGER.isLoggable(Level.WARNING)) break block14;
                            LOGGER.log(Level.WARNING, ne.toString(), ne);
                        }
                    }
                    try {
                        Object validatorFactory = initialContext.lookup("java:comp/ValidatorFactory");
                        if (null != validatorFactory) {
                            appMap.put("javax.faces.validator.beanValidator.ValidatorFactory", validatorFactory);
                            result = true;
                        }
                    }
                    catch (NamingException root) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            String msg = "Could not build a default Bean Validator factory: " + root.getMessage();
                            LOGGER.fine(msg);
                        }
                    }
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block13;
                    LOGGER.fine("Unable to load Beans Validation");
                }
            }
            appMap.put("javax.faces.BEANS_VALIDATION_AVAILABLE", result);
        }
        return result;
    }

    private void setMessageBundle(Application application, Node messageBundle) {
        String bundle;
        if (messageBundle != null && (bundle = this.getNodeText(messageBundle)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setMessageBundle({0})", bundle));
            }
            application.setMessageBundle(bundle);
        }
    }

    private void setDefaultRenderKitId(Application application, Node defaultId) {
        String id;
        if (defaultId != null && (id = this.getNodeText(defaultId)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setDefaultRenderKitId({0})", id));
            }
            application.setDefaultRenderKitId(id);
        }
    }

    private void addActionListener(ServletContext sc, Application application, Node actionListener) {
        Object instance;
        String listener;
        if (actionListener != null && (listener = this.getNodeText(actionListener)) != null && (instance = this.createInstance(sc, listener, ActionListener.class, application.getActionListener(), actionListener)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setActionListeners({0})", listener));
            }
            application.setActionListener((ActionListener)instance);
        }
    }

    private void setNavigationHandler(ServletContext sc, Application application, Node navigationHandler) {
        Class<?> rootType;
        Object instance;
        String handler;
        if (navigationHandler != null && (handler = this.getNodeText(navigationHandler)) != null && (instance = this.createInstance(sc, handler, (rootType = this.findRootType(sc, handler, navigationHandler, new Class[]{ConfigurableNavigationHandler.class, NavigationHandler.class})) != null ? rootType : NavigationHandler.class, application.getNavigationHandler(), navigationHandler)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setNavigationHandlers({0})", handler));
            }
            application.setNavigationHandler((NavigationHandler)instance);
        }
    }

    private void setStateManager(ServletContext sc, Application application, Node stateManager) {
        Object instance;
        String manager;
        if (stateManager != null && (manager = this.getNodeText(stateManager)) != null && (instance = this.createInstance(sc, manager, StateManager.class, application.getStateManager(), stateManager)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setStateManagers({0})", manager));
            }
            application.setStateManager((StateManager)instance);
        }
    }

    private void setViewHandler(ServletContext sc, Application application, Node viewHandler) {
        Object instance;
        String handler;
        if (viewHandler != null && (handler = this.getNodeText(viewHandler)) != null && (instance = this.createInstance(sc, handler, ViewHandler.class, application.getViewHandler(), viewHandler)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setViewHandler({0})", handler));
            }
            application.setViewHandler((ViewHandler)instance);
        }
    }

    private void addELResolver(ServletContext sc, ApplicationAssociate associate, Node elResolver) {
        if (elResolver != null && associate != null) {
            Object elRes;
            String elResolverClass;
            List<ELResolver> resolvers = associate.getELResolversFromFacesConfig();
            if (resolvers == null) {
                resolvers = new ArrayList<ELResolver>();
                associate.setELResolversFromFacesConfig(resolvers);
            }
            if ((elResolverClass = this.getNodeText(elResolver)) != null && (elRes = this.createInstance(sc, elResolverClass, ELResolver.class, null, elResolver)) != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Adding ''{0}'' to ELResolver chain", elResolverClass));
                }
                resolvers.add((ELResolver)elRes);
            }
        }
    }

    private void addPropertyResolver(ServletContext sc, ApplicationAssociate associate, Node propertyResolver) {
        if (propertyResolver != null && associate != null) {
            String resolver;
            Object resolverImpl = associate.getLegacyPRChainHead();
            if (resolverImpl == null) {
                resolverImpl = new DummyPropertyResolverImpl();
            }
            if ((resolver = this.getNodeText(propertyResolver)) != null) {
                resolverImpl = this.createInstance(sc, resolver, PropertyResolver.class, resolverImpl, propertyResolver);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Adding ''{0}'' to PropertyResolver chain", resolverImpl));
                }
            }
            if (resolverImpl != null) {
                associate.setLegacyPRChainHead((PropertyResolver)resolverImpl);
            }
        }
    }

    private void addVariableResolver(ServletContext sc, ApplicationAssociate associate, Node variableResolver) {
        if (variableResolver != null && associate != null) {
            String resolver;
            Object resolverImpl = associate.getLegacyVRChainHead();
            if (resolverImpl == null) {
                resolverImpl = new ChainAwareVariableResolver();
            }
            if ((resolver = this.getNodeText(variableResolver)) != null) {
                resolverImpl = this.createInstance(sc, resolver, VariableResolver.class, resolverImpl, variableResolver);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Adding ''{0}'' to VariableResolver chain", resolverImpl));
                }
            }
            if (resolverImpl != null) {
                associate.setLegacyVRChainHead((VariableResolver)resolverImpl);
            }
        }
    }

    private void setDefaultLocale(Application application, Node defaultLocale) {
        Locale def;
        String defLocale;
        if (defaultLocale != null && (defLocale = this.getNodeText(defaultLocale)) != null && (def = Util.getLocaleFromString(defLocale)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Setting default Locale to ''{0}''", defLocale));
            }
            application.setDefaultLocale(def);
        }
    }

    private void addSupportedLocale(Application application, Node supportedLocale) {
        if (supportedLocale != null) {
            Set<Locale> sLocales = this.getCurrentLocales(application);
            String locString = this.getNodeText(supportedLocale);
            if (locString != null) {
                Locale loc = Util.getLocaleFromString(locString);
                if (loc != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, MessageFormat.format("Adding supported Locale ''{0}''", locString));
                    }
                    sLocales.add(loc);
                }
                application.setSupportedLocales(sLocales);
            }
        }
    }

    private void addResouceBundle(ApplicationAssociate associate, Node resourceBundle) {
        NodeList children;
        if (resourceBundle != null && (children = resourceBundle.getChildNodes()) != null) {
            String baseName = null;
            String var = null;
            ArrayList<Node> descriptions = null;
            ArrayList<Node> displayNames = null;
            int size = children.getLength();
            for (int i = 0; i < size; ++i) {
                Node n = children.item(i);
                if (n.getNodeType() != 1) continue;
                if (BASE_NAME.equals(n.getLocalName())) {
                    baseName = this.getNodeText(n);
                    continue;
                }
                if (VAR.equals(n.getLocalName())) {
                    var = this.getNodeText(n);
                    continue;
                }
                if (RES_DESCRIPTIONS.equals(n.getLocalName())) {
                    if (descriptions == null) {
                        descriptions = new ArrayList<Node>(2);
                    }
                    descriptions.add(n);
                    continue;
                }
                if (!RES_DISPLAY_NAMES.equals(n.getLocalName())) continue;
                if (displayNames == null) {
                    displayNames = new ArrayList<Node>(2);
                }
                displayNames.add(n);
            }
            if (baseName != null && var != null) {
                associate.addResourceBundle(var, new ApplicationResourceBundle(baseName, this.getTextMap(displayNames), this.getTextMap(descriptions)));
            }
        }
    }

    private Set<Locale> getCurrentLocales(Application application) {
        HashSet<Locale> supportedLocales = new HashSet<Locale>();
        Iterator<Locale> i = application.getSupportedLocales();
        while (i.hasNext()) {
            supportedLocales.add(i.next());
        }
        return supportedLocales;
    }

    private void setResourceHandler(ServletContext sc, Application application, Node resourceHandler) {
        Object instance;
        String handler;
        if (resourceHandler != null && (handler = this.getNodeText(resourceHandler)) != null && (instance = this.createInstance(sc, handler, ResourceHandler.class, application.getResourceHandler(), resourceHandler)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setResourceHandler({0})", handler));
            }
            application.setResourceHandler((ResourceHandler)instance);
        }
    }

    private void addSystemEventListener(ServletContext sc, Application application, Node systemEventListener) {
        SystemEventListener selInstance;
        NodeList children = systemEventListener.getChildNodes();
        String listenerClass = null;
        String eventClass = null;
        String sourceClass = null;
        int len = children.getLength();
        for (int j = 0; j < len; ++j) {
            Node n = children.item(j);
            if (n.getNodeType() != 1) continue;
            if (SYSTEM_EVENT_LISTENER_CLASS.equals(n.getLocalName())) {
                listenerClass = this.getNodeText(n);
                continue;
            }
            if (SYSTEM_EVENT_CLASS.equals(n.getLocalName())) {
                eventClass = this.getNodeText(n);
                continue;
            }
            if (!SOURCE_CLASS.equals(n.getLocalName())) continue;
            sourceClass = this.getNodeText(n);
        }
        if (listenerClass != null && (selInstance = (SystemEventListener)this.createInstance(sc, listenerClass, SystemEventListener.class, null, systemEventListener)) != null) {
            try {
                Class<?> eventClazz = this.loadClass(sc, eventClass, this, null);
                Class sourceClazz = sourceClass != null && sourceClass.length() != 0 ? Util.loadClass(sourceClass, this.getClass()) : null;
                application.subscribeToEvent(eventClazz, sourceClazz, selInstance);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Subscribing for event {0} and source {1} using listener {2}", new Object[]{eventClazz.getName(), sourceClazz != null ? sourceClazz.getName() : "ANY", selInstance.getClass().getName()});
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new ConfigurationException(cnfe);
            }
        }
    }

    private void processViewHandlers(ServletContext sc, Application app, LinkedHashMap<String, Node> viewHandlers) {
        WebConfiguration webConfig = WebConfiguration.getInstance();
        if (!webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler) && viewHandlers.containsKey("com.sun.facelets.FaceletViewHandler")) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.application.legacy_facelet_viewhandler_detected", "com.sun.facelets.FaceletViewHandler");
            }
            webConfig.overrideContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler, true);
        }
        for (Node n : viewHandlers.values()) {
            this.setViewHandler(sc, app, n);
        }
    }
}

